//------------------------------------------------------------------------------
// File: AnimalTrap.cs Mapfile = animaltrap.mis XML = animaltrap_vertices.xml
// Secret Satellite map that unlocks Sheep for the Ranch
//------------------------------------------------------------------------------

////////////////////////////////////////////////////////////////////////////////
//! Start and End Task functions
////////////////////////////////////////////////////////////////////////////////
$animaltrapQuest = "Animal Round Up";
//Starts Tasks
function AnimalTrapStartTasks()
{
   InitializeQuestGui();
   GameCamera.FlySpeed = 65;
   tsEnableCommand("BuildCmdData", false);
   slgActivateTask("AnimalTrapTasks");
   TaskModifier.strMarkVertex("AnimalTrapTasks", "AnimalTrapStart", $TSV_AVAIL);
}
// Closes tasks
function endAnimalTasks()
{
   tsEndTask("AnimalTrapTasks");
}
// Resets accept vertex
function resetAnimalTrapTasks()
{
   slgDeactivateTask("AnimalTrapTasks");
   TaskModifier.strResetVertex("Campaign2Tasks", "ATMapAcceptDelay");
   TaskModifier.strMarkVertex("Campaign2Tasks", "ATMapAcceptDelay", $TSV_AVAIL);
}
// Wins the task
function winAnimalTrap()
{
   tsModifyResource($Resource::Experience, 25, true);
   tsModifyResource($Resource::Gold, 100, true);
   // Mark Task as Complete Unlock Sheep
   tsEnableCommand(ProduceSheepCmdData, true);
   TaskModifier.strMarkVertex("Campaign2Tasks", "ReturnAnimalTrap", $TSV_AVAIL);
}

// Lose Condition
// Checks to see if Hero is healing after all gunslingers have died 
function AnimalTrapHeroDeath::onExit(%this)
{
   if(herocharacter.isHealing) 
   {
     tsSendTaskPopUpDlg("ID_AnimalTrap", "ID_AnimalTrapHeroDeath", $TaskButton::More, "Herocharacter");    
   }
}
////////////////////////////////////////////////////////////////////////////////
//! Intro Dialog
////////////////////////////////////////////////////////////////////////////////

function AnimalTrapStart::onEnter()
{
   TaskModifier.strMarkVertex("AnimalTrapTasks", "AnimalTrapStart", $TSV_CMPLETE);
   
   tsSendTaskPopUpDlg("ID_AnimalTrap", "ID_AnimalTrapIntro", $TaskButton::More, "zookeeper");
   tsSendTaskPopUpDlg("ID_AnimalTrap", "ID_AnimalTrapHero", $TaskButton::More, "Herocharacter");
   tsSendTaskPopUpDlg("ID_AnimalTrap", "ID_AnimalTrapPlan", $TaskButton::More, "zookeeper");
   tsSendTaskPopUpDlg("ID_AnimalTrap", "ID_AnimalTrapCapture", $TaskButton::Okay, "zookeeper", "ID_AnimalTrapCapture");
}
function AnimalTrapExtraHelp::onExit()
{
   tsConvertObjTeam("zoogun1",1);
   tsConvertObjTeam("zoogun2",1);
   tsConvertObjTeam("zoogun3",1);
   
   //Quest log
   tsAddQuestToTracker(true, $animaltrapQuest, "", "Capture a deer, a bear, and a Sasquatch by luring them into the holding pens. Escape out the back and the trap will be set. Each animal needs to be captured in a separate holding pen.", "Reward: Unknown");
   tsReadyQuest($animaltrapQuest);
   tsAddTaskToTracker($animaltrapQuest, "Capture a deer.", "Capture a deer.");
   tsAddTaskToTracker($animaltrapQuest, "Capture a bear.", "Capture a bear.");
   tsAddTaskToTracker($animaltrapQuest, "Capture the legendary Sasquatch.", "Capture the legendary Sasquatch.");
   
   //Remove Cell1 Trapdoor
   RemoveObject(trapdoor1);
   trapdoor1.setTransform("-425.5 -412 5");
   PlaceObject(trapdoor1);
   
   //Remove Cell2 Trapdoor
   RemoveObject(trapdoor2);
   trapdoor2.setTransform("-425.5 -388 5");
   PlaceObject(trapdoor2);
   
   //Remove Cell3 Trapdoor
   RemoveObject(trapdoor3);
   trapdoor3.setTransform("-425.5 -364 5");
   PlaceObject(trapdoor3);
}

////////////////////////////////////////////////////////////////////////////////
//! Animal Trap 
////////////////////////////////////////////////////////////////////////////////
//**************** Cell 1 ********************

function PlayerTrapDoor1::OnExit(%this)
{
   %cell1Trap = 0;
   
   //Check to see if zone has animal in it
   %objList = tsCreateObjList();
   tsFindObjTypeOnMap("townbear", "char", %objList);
   %objList2 = tsCreateObjList();
   tsFindObjTypeOnMap("sasquatch", "char", %objList2);
   %objList3 = tsCreateObjList();
   tsFindObjTypeOnMap("towndeer", "char", %objList3);  
   
   // Check for Bear
   if(%objList.getSize() > 0)
   {
      %char = %objList.getID(0);
      if(%char.isInZone(cell1zone))
      {
         //Close Trap Door
         RemoveObject(cell1gateleft);
         cell1gateleft.rotateZ(90);
         PlaceObject(cell1gateleft);
         
         RemoveObject(cell1gateright);
         cell1gateright.rotateZ(-90);
         PlaceObject(cell1gateright);
         
         //Replace Cell1 Trap Door
         RemoveObject(trapdoor1);
         trapdoor1.setTransform("-425.5 -406 5");
         PlaceObject(trapdoor1);
         
         tsConvertObjTeam(%char, 0);
         tsMoveObjToTarget(%char, "-416 -406"); 
         
         TaskModifier.strMarkVertex("AnimalTrapTasks", "BearTrapComplete", $TSV_CMPLETE);
         TaskModifier.strMarkVertex("AnimalTrapTasks", "PlayerTriggerCell1", $TSV_CLOSED);
         
          //Quest log
         tsCompleteTaskInTracker($animaltrapQuest, "Capture a bear.");
         
         %cell1Trap = 1;
      }
   }
   // Check for Sasquatch
   if(%objList2.getSize() > 0 && %cell1Trap == 0)
   {
      %char2 = %objList2.getID(0);
      if(%char2.isInZone(cell1zone))
      {
         //Close Trap Door
         RemoveObject(cell1gateleft);
         cell1gateleft.rotateZ(90);
         PlaceObject(cell1gateleft);
         
         RemoveObject(cell1gateright);
         cell1gateright.rotateZ(-90);
         PlaceObject(cell1gateright);
         
         //Replace Cell1 Trap Door
         RemoveObject(trapdoor1);
         trapdoor1.setTransform("-425.5 -406 5");
         PlaceObject(trapdoor1);
         
         tsConvertObjTeam(%char2,0);
         tsMoveObjToTarget(%char2, "-416 -406"); 
         
         TaskModifier.strMarkVertex("AnimalTrapTasks", "SasquatchTrapComplete", $TSV_CMPLETE);
         TaskModifier.strMarkVertex("AnimalTrapTasks", "PlayerTriggerCell1", $TSV_CLOSED);
         
          //Quest log
         tsCompleteTaskInTracker($animaltrapQuest, "Capture the legendary Sasquatch.");
         
         %cell1Trap = 1;
         return;
      }
   }
   // Check for Deer
   if(%objList3.getSize() > 0 && %cell1Trap == 0)
   {
      %char3 = %objList3.getID(0);
      if(%char3.isInZone(cell1zone))
      {
         //Close Trap Door
         RemoveObject(cell1gateleft);
         cell1gateleft.rotateZ(90);
         PlaceObject(cell1gateleft);
         
         RemoveObject(cell1gateright);
         cell1gateright.rotateZ(-90);
         PlaceObject(cell1gateright);
         
         //Replace Cell1 Trap Door
         RemoveObject(trapdoor1);
         trapdoor1.setTransform("-425.5 -406 5");
         PlaceObject(trapdoor1);
         
         tsConvertObjTeam(%char3,0);
         tsMoveObjToTarget(%char3, "-415 -406"); 
         
         TaskModifier.strMarkVertex("AnimalTrapTasks", "DeerTrapComplete", $TSV_CMPLETE);
         TaskModifier.strMarkVertex("AnimalTrapTasks", "PlayerTriggerCell1", $TSV_CLOSED);
         
          //Quest log
         tsCompleteTaskInTracker($animaltrapQuest, "Capture a deer.");
         
         %cell1Trap = 1;
         return;
      }
   }
   tsDestroyObjList(%objList);
   tsDestroyObjList(%objList2);
   tsDestroyObjList(%objList3);

   if(%cell1Trap == 0)
   {
      %timer = new SLTimer()
      {
         time = 0;
      };
      %timer.notifyOnFire(PlayerCell1reset, %timer);
   }
   
}
function SLTimer::PlayerCell1reset(%timer)
{
   TaskModifier.strResetVertex("AnimalTrapTasks", "PlayerTriggerCell1");
   TaskModifier.strMarkVertex("AnimalTrapTasks", "PlayerTriggerCell1", $TSV_AVAIL);
}

//**************** Cell 2 ********************

function PlayerTrapDoor2::OnExit(%this)
{
   
   %cellTrap = 0;
   
   
   //Check to see if zone has animal in it
   %objList = tsCreateObjList();
   tsFindObjTypeOnMap("townbear", "char", %objList);
   %objList2 = tsCreateObjList();
   tsFindObjTypeOnMap("sasquatch", "char", %objList2);
   %objList3 = tsCreateObjList();
   tsFindObjTypeOnMap("towndeer", "char", %objList3);  
   // Check for Bear
   if(%objList.getSize() > 0)
   {
      %char = %objList.getID(0);
      if(%char.isInZone(cell2zone))
      {
         //Close Trap Door
         RemoveObject(cell2gateleft);
         cell2gateleft.rotateZ(90);
         PlaceObject(cell2gateleft);
         
         RemoveObject(cell2gateright);
         cell2gateright.rotateZ(-90);
         PlaceObject(cell2gateright);
         
         //Replace Cell2 Trap Door
         RemoveObject(trapdoor2);
         trapdoor2.setTransform("-425.5 -382 5");
         PlaceObject(trapdoor2);
         
         tsConvertObjTeam(%char,0);
         tsMoveObjToTarget(%char, "-416 -382"); 
         
         TaskModifier.strMarkVertex("AnimalTrapTasks", "BearTrapComplete", $TSV_CMPLETE);
         TaskModifier.strMarkVertex("AnimalTrapTasks", "PlayerTriggerCell2", $TSV_CLOSED);
         
          //Quest log
         tsCompleteTaskInTracker($animaltrapQuest, "Capture a bear.");
         
         %cellTrap = 1;
         return;
      }
   }
   // Check for Sasquatch
   if(%objList2.getSize() > 0 && %cellTrap == 0)
   {
      %char2 = %objList2.getID(0);
      if(%char2.isInZone(cell2zone))
      {
         //Close Trap Door
         RemoveObject(cell2gateleft);
         cell2gateleft.rotateZ(90);
         PlaceObject(cell2gateleft);
         
         RemoveObject(cell2gateright);
         cell2gateright.rotateZ(-90);
         PlaceObject(cell2gateright);
         
         //Replace Cell2 Trap Door
         RemoveObject(trapdoor2);
         trapdoor2.setTransform("-425.5 -382 5");
         PlaceObject(trapdoor2);
         
         tsConvertObjTeam(%char2,0);
         tsMoveObjToTarget(%char2, "-416 -382");
         
          //Quest log
         tsCompleteTaskInTracker($animaltrapQuest, "Capture the legendary Sasquatch.");
         
         TaskModifier.strMarkVertex("AnimalTrapTasks", "SasquatchTrapComplete", $TSV_CMPLETE);
         TaskModifier.strMarkVertex("AnimalTrapTasks", "PlayerTriggerCell2", $TSV_CLOSED);
         %cellTrap = 1;
         return;
      }
   }
   // Check for Deer
   if(%objList3.getSize() > 0 && %cellTrap == 0)
   {
      %char3 = %objList3.getID(0);
      if(%char3.isInZone(cell2zone))
      {
         //Close Trap Door
         RemoveObject(cell2gateleft);
         cell2gateleft.rotateZ(90);
         PlaceObject(cell2gateleft);
         
         RemoveObject(cell2gateright);
         cell2gateright.rotateZ(-90);
         PlaceObject(cell2gateright);
         
         //Replace Cell2 Trap Door
         RemoveObject(trapdoor2);
         trapdoor2.setTransform("-425.5 -382 5");
         PlaceObject(trapdoor2);
         
         tsConvertObjTeam(%char3,0);
         tsMoveObjToTarget(%char3, "-416 -382");
         
          //Quest log
         tsCompleteTaskInTracker($animaltrapQuest, "Capture a deer.");
         
         TaskModifier.strMarkVertex("AnimalTrapTasks", "DeerTrapComplete", $TSV_CMPLETE);
         TaskModifier.strMarkVertex("AnimalTrapTasks", "PlayerTriggerCell2", $TSV_CLOSED);
         %cellTrap = 1;
         return;
      }
   }
   tsDestroyObjList(%objList);
   tsDestroyObjList(%objList2);
   tsDestroyObjList(%objList3);

   if(%cellTrap == 0)
   {
      %timer = new SLTimer()
      {
         time = 0;
      };
      %timer.notifyOnFire(PlayerCell2reset, %timer);
   }
   
}
function SLTimer::PlayerCell2reset(%timer)
{
   TaskModifier.strResetVertex("AnimalTrapTasks", "PlayerTriggerCell2");
   TaskModifier.strMarkVertex("AnimalTrapTasks", "PlayerTriggerCell2", $TSV_AVAIL);
}

//**************** Cell 3 ********************


function PlayerTrapDoor3::OnExit(%this)
{
   
   %cellTrap = 0;
   
   //Check to see if zone has animal in it
   %objList = tsCreateObjList();
   tsFindObjTypeOnMap("townbear", "char", %objList);
   %objList2 = tsCreateObjList();
   tsFindObjTypeOnMap("sasquatch", "char", %objList2);
   %objList3 = tsCreateObjList();
   tsFindObjTypeOnMap("towndeer", "char", %objList3);  
   // Check for Bear
   if(%objList.getSize() > 0)
   {
      %char = %objList.getID(0);
      if(%char.isInZone(cell3zone))
      {
         //Close Trap Door
         RemoveObject(cell3gateleft);
         cell3gateleft.rotateZ(90);
         PlaceObject(cell3gateleft);
         
         RemoveObject(cell3gateright);
         cell3gateright.rotateZ(-90);
         PlaceObject(cell3gateright);
         
         //Replace Cell3 Trap Door
         RemoveObject(trapdoor3);
         trapdoor3.setTransform("-425.5 -358 5");
         PlaceObject(trapdoor3);
         
         tsConvertObjTeam(%char,0);
         tsMoveObjToTarget(%char, "-416 -358"); 
         
         TaskModifier.strMarkVertex("AnimalTrapTasks", "BearTrapComplete", $TSV_CMPLETE);
         TaskModifier.strMarkVertex("AnimalTrapTasks", "PlayerTriggerCell3", $TSV_CLOSED);
         
          //Quest log
         tsCompleteTaskInTracker($animaltrapQuest, "Capture a bear.");
         
         %cellTrap = 1;
      }
   }
   // Check for Sasquatch
   if(%objList2.getSize() > 0 && %cellTrap == 0)
   {
      %char2 = %objList2.getID(0);
      if(%char2.isInZone(cell3zone))
      {
         
         tsConvertObjTeam(%char2, 0);
         tsMoveObjToTarget(%char2, "-416 -358");
         
         //Close Trap Door
         RemoveObject(cell3gateleft);
         cell3gateleft.rotateZ(90);
         PlaceObject(cell3gateleft);
         
         RemoveObject(cell3gateright);
         cell3gateright.rotateZ(-90);
         PlaceObject(cell3gateright);
         
         //Replace Cell3 Trap Door
         RemoveObject(trapdoor3);
         trapdoor3.setTransform("-425.5 -358 5");
         PlaceObject(trapdoor3);
         
         //Quest log
         tsCompleteTaskInTracker($animaltrapQuest, "Capture the legendary Sasquatch.");
         
         TaskModifier.strMarkVertex("AnimalTrapTasks", "SasquatchTrapComplete", $TSV_CMPLETE);
         TaskModifier.strMarkVertex("AnimalTrapTasks", "PlayerTriggerCell3", $TSV_CLOSED);
         %cellTrap = 1;
      }
   }
   // Check for Deer
   if(%objList3.getSize() > 0 && %cellTrap == 0)
   {
      %char3 = %objList3.getID(0);
      if(%char3.isInZone(cell2zone))
      {
         //Close Trap Door
         RemoveObject(cell3gateleft);
         cell3gateleft.rotateZ(90);
         PlaceObject(cell3gateleft);
         
         RemoveObject(cell3gateright);
         cell3gateright.rotateZ(-90);
         PlaceObject(cell3gateright);
         
         //Replace Cell3 Trap Door
         RemoveObject(trapdoor3);
         trapdoor3.setTransform("-425.5 -358 5");
         PlaceObject(trapdoor3);
         
         tsConvertObjTeam(%char3,0);
         tsMoveObjToTarget(%char3, "-416 -358");
         
          //Quest log
         tsCompleteTaskInTracker($animaltrapQuest, "Capture a deer.");
         
         TaskModifier.strMarkVertex("AnimalTrapTasks", "DeerTrapComplete", $TSV_CMPLETE);
         TaskModifier.strMarkVertex("AnimalTrapTasks", "PlayerTriggerCell3", $TSV_CLOSED);
         %cellTrap = 1;
      }
   }
   tsDestroyObjList(%objList);
   tsDestroyObjList(%objList2);
   tsDestroyObjList(%objList3);

   if(%cellTrap == 0)
   {
      %timer = new SLTimer()
      {
         time = 0;
      };
      %timer.notifyOnFire(PlayerCell3reset, %timer);
   }
}
function SLTimer::PlayerCell3reset(%timer)
{
   TaskModifier.strResetVertex("AnimalTrapTasks", "PlayerTriggerCell3");
   TaskModifier.strMarkVertex("AnimalTrapTasks", "PlayerTriggerCell3", $TSV_AVAIL);
}
// Capture all 3 Animals
function TrapAllAnimals::OnExit(%this)
{
   tsSendTaskPopUpDlg("ID_AnimalTrap", "ID_AnimalTrapCaughtAll", $TaskButton::Okay, "Herocharacter", "ID_AnimalTrapCaughtAll");   
}
function AnimalTrapComplete::OnExit(%this)
{
   tsSendTaskClickDlg("ID_AnimalTrap", "ID_AnimalTrapComplete", $TaskButton::Accept, "zookeeper", "ID_AnimalTrapComplete");   
}
function AnimalTrapReturn::OnExit(%this)
{
   %scenario = new SLScenario() 
   {
      stack = false;
   };
   LoadScenario(%scenario, endAnimalTasks, winAnimalTrap);
   
   // complete the animal trap satellite
   mapsatellite_animaltrap.disabled = false;
}
